dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

LManager:AddNewTable( 1, 8, 180, 390, "assets/images/table/island_8", "assets/images/food/item_mark1", "B" );
LManager:AddNewTable( 2, 4, 280, 235, "assets/images/table/island", "assets/images/food/item_mark3", "R" );
--LManager:AddNewTable( 3, 2, 270, 230, "assets/images/table/island_2", "assets/images/food/item_mark4", "R" );


useFloAsServer = 0;
useWineTable = 1;
numMoodBoosts = 3;
numServers = 1;
maxCoupleHappiness = 400;

-- Group 1

guest = LManager.GenGuest(female01);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = female01;
guest.percentRequestMusic = 50;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 3, 3000);

-- Group 2

guest = LManager.GenGuest(aunt);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = aunt;
guest.percentRequestDrink = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = male04;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(4, 6, 17000);


-- Group 3

guest = LManager.GenGuest(female02);
guest.matchType = table1;
guest.percentRequestDrink = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = aunt;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(7, 8, 26000);


-- Group 4

guest = LManager.GenGuest(female02);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = female04;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(9, 11, 40000);

-- Group 4

guest = LManager.GenGuest(male03);
guest.matchType = NOT_GUEST + female02;
guest.percentRequestMusic = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = aunt;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(12, 13, 60000);

-- Group 5

guest = LManager.GenGuest(female02);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(14, 15, 80000);

-- Group 6

guest = LManager.GenGuest(uncle);
guest.matchType = NOT_GUEST + female02;
guest.percentRequestDrink = 50;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(16, 18, 110000);

-- Group 7

guest = LManager.GenGuest(female02);
guest.matchType = table2;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = male03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(19, 21, 135000);

-- Group 7

guest = LManager.GenGuest(female02);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male03);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + female02;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female02);
guest.matchType = table1;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(22, 25, 160000);


LManager:AdjustGuestTolerance(135);

LManager:SetLevelSetting ("cakeTipDelay", 110000); 
LManager:SetLevelSetting ("cakeTipChance", 100);

LManager:AddQuinnEvent( "fx/fx_bees.lua", 600, 300, 80000 );

LManager:SetLevelSetting ("speakerDelay", 150000); 
LManager:SetLevelSetting ("speakerChance", 40);

LManager:SetLevelSetting ("dogDelay", 50000); 
LManager:SetLevelSetting ("dogChance", 100);


--LManager:AddReseatingRequestForGuest(50000, female03);


-- Set up the Level Settings
LManager:SetLevelNumber(4,10);
LManager:SetLevelScores(11500, 15500);
LManager:SetLevelTime(300000);
LManager:SetLevelSetting ("blaster", 1);

LManager:SetMusic("assets/audio/music/Big Band 4.ogg","assets/audio/music/Dance Dance 1.ogg","assets/audio/music/new_dance_2.ogg");
LManager:SetBackgroundImage("assets/images/bg_island");
LManager:SetChairImage("assets/images/table/chair04");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );